﻿using System;
using System.Security.Permissions;
using Microsoft.SharePoint;
using Microsoft.SharePoint.Utilities;
using Microsoft.SharePoint.Workflow;

namespace Code6587EN.Ch04.ApplySiteBranding
{
    /// <summary>
    /// Web Events
    /// </summary>
    public class ApplySiteBranding : SPWebEventReceiver
    {
        private static Guid BrandingFeatureId = new Guid("1150dec7-4af6-44d8-b241-d976d26b723c");

        /// <summary>
        /// A site was provisioned.
        /// </summary>
        public override void WebProvisioned(SPWebEventProperties properties)
        {
            base.WebProvisioned(properties);

            // Get the SharePoint Site that was created
            using (var web = properties.Web)
            {
                // Ensure the Site is not null
                if (web != null)
                {
                    // If the feature is not activated on the Site, activate it
                    if (web.Features[BrandingFeatureId] == null)
                        web.Features.Add(BrandingFeatureId);
                }
            }
        }
    }
}